<?php

namespace App\Models;

use CodeIgniter\Model;

class LiburNasionalModel extends Model
{
    protected $table            = 'libur_nasional';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_libur', 'tanggal_mulai', 'tanggal_akhir', 'deskripsi'];

    // Helper untuk mengecek apakah tanggal tertentu adalah hari libur nasional
    public function isLibur($date)
    {
        return $this->where('tanggal_mulai <=', $date)
                    ->where('tanggal_akhir >=', $date)
                    ->first();
    }
}