<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-menu {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        background: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
    }
    .card-header-menu {
        padding: 20px;
        color: white;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .header-blue { background: linear-gradient(135deg, #435ebe 0%, #25396f 100%); }
    .header-green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
    .nav-pills .nav-link {
        border-radius: 50px;
        padding: 12px 30px;
        font-weight: 600;
        color: #607080;
        background: #fff;
        border: 2px solid #eef2f7;
        margin-right: 10px;
        transition: all 0.3s;
    }
    .nav-pills .nav-link.active {
        background: #435ebe;
        color: #fff;
        border-color: #435ebe;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.3);
    }
    .form-control, .form-select {
        border-radius: 10px;
        padding: 10px 15px;
        border: 1px solid #eef2f7;
        background-color: #fcfcfc;
    }
    .form-control:focus, .form-select:focus {
        border-color: #435ebe;
        box-shadow: 0 0 0 4px rgba(67, 94, 190, 0.1);
    }
    .btn-filter {
        border-radius: 10px;
        padding: 12px;
        font-weight: 600;
        width: 100%;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
        transition: all 0.3s;
        margin-top: 10px;
    }
    .table-modern {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 10px; 
    }
    .table-modern thead th {
        background-color: #f8f9fa;
        color: #607080;
        font-weight: 700;
        padding: 15px;
        border: none;
    }
    .table-modern tbody tr {
        background-color: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,0.02);
        transition: transform 0.2s;
    }
    .table-modern tbody tr:hover {
        transform: scale(1.01);
        z-index: 10;
        position: relative;
    }
    .table-modern td {
        padding: 15px;
        vertical-align: middle;
        border: none;
    }
    .table-modern td:first-child {
        border-top-left-radius: 10px;
        border-bottom-left-radius: 10px;
    }
    .table-modern td:last-child {
        border-top-right-radius: 10px;
        border-bottom-right-radius: 10px;
    }
    .status-badge {
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 700;
        text-transform: uppercase;
    }
    .status-hadir { background: #d1e7dd; color: #198754; }
    .status-terlambat { background: #f8d7da; color: #dc3545; }
    .status-sakit { background: #cff4fc; color: #0dcaf0; }
    .status-izin { background: #fff3cd; color: #ffc107; }
    .status-alfa { background: #e2e3e5; color: #383d41; }
    .status-cepat-pulang { background: #fff3cd; color: #d39e00; }
    .bulk-toolbar {
        background: #eef2ff; padding: 15px; border-radius: 12px; margin-bottom: 20px; border: 1px solid #435ebe;
    }
    .item-check { width: 1.3em; height: 1.3em; cursor: pointer; }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Koreksi Kehadiran Sekolah</h3>
            <p class="text-subtitle text-muted">Cari dan perbaiki data absensi (Masuk/Pulang).</p>
        </div>
    </div>
</div>

<div class="page-content">
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')) : ?>
        <div class="alert alert-danger alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
            <i class="bi bi-exclamation-circle-fill me-2"></i> <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= (!isset($active_tab) || $active_tab == 'guru') ? 'active' : '' ?>" id="pills-guru-tab" data-bs-toggle="pill" data-bs-target="#pills-guru" type="button">
                <i class="bi bi-person-video3 me-2"></i> Koreksi Guru
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= (isset($active_tab) && $active_tab == 'siswa') ? 'active' : '' ?>" id="pills-siswa-tab" data-bs-toggle="pill" data-bs-target="#pills-siswa" type="button">
                <i class="bi bi-people-fill me-2"></i> Koreksi Siswa
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade <?= (!isset($active_tab) || $active_tab == 'guru') ? 'show active' : '' ?>" id="pills-guru" role="tabpanel">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card card-menu">
                        <div class="card-header-menu header-blue">
                            <i class="bi bi-search fs-4"></i> Filter Data Guru
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/koreksi/filter') ?>" method="get">
                                <input type="hidden" name="user_type" value="guru">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Awal</label>
                                        <input type="date" name="tgl_awal" class="form-control" required value="<?= isset($p_awal) ? $p_awal : date('Y-m-d') ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Akhir</label>
                                        <input type="date" name="tgl_akhir" class="form-control" required value="<?= isset($p_akhir) ? $p_akhir : date('Y-m-d') ?>">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary btn-filter shadow-sm" style="background: #435ebe; border-color: #435ebe;">
                                    <i class="bi bi-search me-2"></i> Tampilkan Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade <?= (isset($active_tab) && $active_tab == 'siswa') ? 'show active' : '' ?>" id="pills-siswa" role="tabpanel">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card card-menu">
                        <div class="card-header-menu header-green">
                            <i class="bi bi-search fs-4"></i> Filter Data Siswa
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/koreksi/filter') ?>" method="get">
                                <input type="hidden" name="user_type" value="siswa">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Pilih Kelas</label>
                                    <select name="kelas_id" class="form-select" required>
                                        <option value="">-- Pilih Kelas --</option>
                                        <?php foreach($kelas as $k): ?>
                                            <option value="<?= $k['id'] ?>" <?= (isset($p_kelas) && $p_kelas == $k['id']) ? 'selected' : '' ?>>
                                                <?= $k['nama_kelas'] ?> - <?= $k['jurusan'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Awal</label>
                                        <input type="date" name="tgl_awal" class="form-control" required value="<?= isset($p_awal) ? $p_awal : date('Y-m-d') ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-bold">Tanggal Akhir</label>
                                        <input type="date" name="tgl_akhir" class="form-control" required value="<?= isset($p_akhir) ? $p_akhir : date('Y-m-d') ?>">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success btn-filter shadow-sm" style="background: #11998e; border-color: #11998e;">
                                    <i class="bi bi-search me-2"></i> Tampilkan Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php if ($tampil_data): ?>
    
    <form action="<?= base_url('admin/koreksi/bulkAction') ?>" method="post" id="bulkForm" class="mt-4">
        <?= csrf_field() ?>
        
        <input type="hidden" name="bulk_action" id="bulk_action_input">
        <input type="hidden" name="bulk_status" id="bulk_status_input">
        <input type="hidden" name="bulk_jam_masuk" id="bulk_jam_masuk_input">
        <input type="hidden" name="bulk_jam_pulang" id="bulk_jam_pulang_input">
        <input type="hidden" name="bulk_keterangan" id="bulk_keterangan_input">

        <div class="bulk-toolbar d-flex flex-wrap align-items-center justify-content-between gap-3">
            <div class="d-flex align-items-center gap-2">
                <input type="checkbox" class="form-check-input fs-5" id="checkAll">
                <label for="checkAll" class="fw-bold cursor-pointer">Pilih Semua</label>
            </div>
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-primary" onclick="openBulkEditModal()">
                    <i class="bi bi-pencil-square me-2"></i> Edit Terpilih (Massal)
                </button>
                
            </div>
        </div>

        <div class="card card-modern">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th width="5%">#</th>
                                <th>Tanggal</th>
                                <th>Nama Lengkap</th>
                                <th>Jam Masuk</th>
                                <th>Jam Pulang</th>
                                <th>Status</th>
                                <th width="15%" class="text-center">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(empty($absensi)): ?>
                            <tr><td colspan="7" class="text-center py-4 text-muted">Tidak ada data ditemukan.</td></tr>
                            <?php else: ?>
                            <?php foreach($absensi as $row): ?>
                            <tr>
                                <td>
                                    <input type="checkbox" name="selected_items[]" class="form-check-input item-check" 
                                           value="<?= $row['user_id'].'|'.$row['tanggal'].'|'.$row['user_type'] ?>">
                                </td>
                                <td><span class="fw-bold text-dark"><?= date('d/m/Y', strtotime($row['tanggal'])) ?></span></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar avatar-sm bg-light-primary me-3 text-primary fw-bold">
                                            <?= substr($row['nama_lengkap'], 0, 1) ?>
                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-dark" style="font-size: 0.9rem;"><?= $row['nama_lengkap'] ?></h6>
                                            <small class="text-muted" style="font-size: 0.75rem;"><?= $row['nomor_induk'] ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td><?= $row['jam_masuk'] ?></td>
                                <td><?= $row['jam_pulang'] ?></td>
                                <td>
                                    <?php 
                                        $statusClass = 'status-' . strtolower(str_replace(' ', '-', $row['status']));
                                        if ($row['status'] == 'Cepat Pulang') $statusClass = 'status-cepat-pulang';
                                    ?>
                                    <span class="status-badge <?= $statusClass ?>"><?= $row['status'] ?></span>
                                </td>
                                <td class="text-center">
                                    <?php if(isset($row['id']) && $row['id']): ?>
                                        <a href="<?= base_url('admin/absensi/edit/' . $row['id']) ?>" class="btn btn-warning btn-sm" title="Edit Manual"><i class="bi bi-pencil"></i></a>
                                        <a href="<?= base_url('admin/koreksi/delete/' . $row['id']) ?>" class="btn btn-danger btn-sm" title="Hapus (Reset Alfa)" onclick="return confirm('Hapus data ini? (Kembali ke Alfa)')"><i class="bi bi-trash"></i></a>
                                    <?php else: ?>
                                        <a href="<?= base_url('admin/absensi/input') . '?user_id='.$row['user_id'].'&user_type='.$row['user_type'].'&tanggal='.$row['tanggal'] ?>" class="btn btn-primary btn-sm" title="Input Manual"><i class="bi bi-plus"></i></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </form>
    <?php endif; ?>
</div>

<div class="modal fade" id="bulkEditModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 15px; border:none;">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold"><i class="bi bi-pencil-square me-2"></i> Koreksi Massal</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="mb-3">
                    <label class="form-label fw-bold">Status Kehadiran</label>
                    <select id="modal_status" class="form-select">
                        <option value="Hadir">Hadir</option>
                        <option value="Sakit">Sakit</option>
                        <option value="Izin">Izin</option>
                        <option value="Alfa">Alfa</option>
                        <option value="Terlambat">Terlambat</option>
                    </select>
                </div>

                <div class="alert alert-info small py-2">
                    <i class="bi bi-info-circle me-1"></i> Jika pilih <b>Hadir/Terlambat</b>, Anda bisa mengisi jam masuk saja agar user bisa scan pulang nanti.
                </div>

                <div class="row">
                    <div class="col-6 mb-3">
                        <label class="form-label fw-bold">Jam Masuk</label>
                        <input type="time" id="modal_jam_masuk" class="form-control">
                        <small class="text-muted" style="font-size: 10px;">Kosongkan = default 07:00</small>
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label fw-bold">Jam Pulang</label>
                        <input type="time" id="modal_jam_pulang" class="form-control">
                        <small class="text-muted" style="font-size: 10px;">Kosongkan = Belum Pulang (Bisa Scan)</small>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Keterangan</label>
                    <textarea id="modal_keterangan" class="form-control" rows="2" placeholder="Contoh: Koreksi Massal oleh Admin"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-primary fw-bold" onclick="submitBulkEdit()">Simpan Perubahan</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('checkAll')?.addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.item-check');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    function getCheckedCount() {
        return document.querySelectorAll('.item-check:checked').length;
    }

    function openBulkEditModal() {
        if(getCheckedCount() === 0) {
            Swal.fire('Peringatan', 'Silakan pilih data terlebih dahulu!', 'warning');
            return;
        }
        var myModal = new bootstrap.Modal(document.getElementById('bulkEditModal'));
        myModal.show();
    }

    function submitBulkEdit() {
        document.getElementById('bulk_status_input').value = document.getElementById('modal_status').value;
        document.getElementById('bulk_jam_masuk_input').value = document.getElementById('modal_jam_masuk').value;
        document.getElementById('bulk_jam_pulang_input').value = document.getElementById('modal_jam_pulang').value;
        document.getElementById('bulk_keterangan_input').value = document.getElementById('modal_keterangan').value;
        
        document.getElementById('bulk_action_input').value = 'update';

        document.getElementById('bulkForm').submit();
    }

    function submitDelete() {
        if(getCheckedCount() === 0) {
            Swal.fire('Peringatan', 'Silakan pilih data terlebih dahulu!', 'warning');
            return;
        }
        
        Swal.fire({
            title: 'Hapus Data Terpilih?',
            text: "Data absensi yang dipilih akan dihapus (Reset ke Alfa).",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Ya, Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('bulk_action_input').value = 'delete';
                document.getElementById('bulkForm').submit();
            }
        })
    }
</script>
<?= $this->endSection() ?>