<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-filter {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.05);
        overflow: hidden;
        background: #fff;
    }

    .card-header-gradient {
        background: linear-gradient(135deg, #435ebe 0%, #25396f 100%);
        padding: 40px 30px;
        color: white;
        position: relative;
    }

    .card-header-gradient::before {
        content: '';
        position: absolute;
        top: -30px;
        right: -30px;
        width: 150px;
        height: 150px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }

    .card-header-gradient::after {
        content: '';
        position: absolute;
        bottom: 20px;
        left: 20px;
        width: 60px;
        height: 60px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }

    .form-label-custom {
        font-weight: 700;
        color: #555;
        margin-bottom: 10px;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .form-control-modern {
        border: 2px solid #eef2f7;
        border-radius: 12px;
        padding: 12px 15px;
        font-weight: 500;
        transition: all 0.3s;
        background-color: #fcfcfc;
    }
    
    .form-control-modern:focus {
        border-color: #435ebe;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.1);
        background: #fff;
    }

    .input-group-text-modern {
        background: #f8f9fa;
        border: 2px solid #eef2f7;
        border-right: none;
        border-radius: 12px 0 0 12px;
        color: #435ebe;
        padding-left: 15px;
        padding-right: 15px;
    }

    .form-control-group {
        border-left: none;
        border-radius: 0 12px 12px 0;
    }

    .btn-print {
        background: linear-gradient(90deg, #435ebe, #25396f);
        border: none;
        border-radius: 12px;
        padding: 15px 30px;
        font-weight: 700;
        font-size: 1rem;
        box-shadow: 0 4px 15px rgba(67, 94, 190, 0.3);
        transition: all 0.3s;
        color: white;
        width: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 10px;
    }

    .btn-print:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 94, 190, 0.4);
        color: white;
    }

    .info-badge {
        background: rgba(255,255,255,0.2);
        padding: 5px 15px;
        border-radius: 30px;
        font-size: 0.85rem;
        backdrop-filter: blur(5px);
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Cetak Laporan</h3>
            <p class="text-subtitle text-muted">Filter data absensi untuk dicetak ke PDF.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active" aria-current="page">Laporan</li>
            </ol>
        </nav>
    </div>
</div>

<div class="page-content">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card card-filter">
                <div class="card-header-gradient text-center">
                    <div class="d-inline-block p-3 rounded-circle bg-white bg-opacity-25 mb-3">
                        <i class="bi bi-printer-fill fs-1 text-white"></i>
                    </div>
                    <h4 class="text-white fw-bold mb-2">Filter Laporan Absensi</h4>
                    <p class="text-white text-opacity-75 mb-0">Pilih periode dan kategori user</p>
                </div>

                <div class="card-body p-4 p-md-5">
                    <form action="<?= base_url('admin/laporan/cetak') ?>" method="post" target="_blank">
                        <?= csrf_field() ?>

                        <div class="row g-4">
                            <div class="col-md-6">
                                <label class="form-label-custom">Tanggal Awal</label>
                                <div class="input-group">
                                    <span class="input-group-text input-group-text-modern"><i class="bi bi-calendar-event"></i></span>
                                    <input type="date" name="tgl_awal" class="form-control form-control-modern form-control-group" required value="<?= date('Y-m-01') ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label-custom">Tanggal Akhir</label>
                                <div class="input-group">
                                    <span class="input-group-text input-group-text-modern"><i class="bi bi-calendar-check"></i></span>
                                    <input type="date" name="tgl_akhir" class="form-control form-control-modern form-control-group" required value="<?= date('Y-m-d') ?>">
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label-custom">Kategori User</label>
                                <div class="row g-3">
                                    <div class="col-4">
                                        <input type="radio" class="btn-check" name="user_type" id="all" value="" checked>
                                        <label class="btn btn-outline-primary w-100 py-3 fw-bold rounded-4" for="all">
                                            <i class="bi bi-people-fill d-block fs-4 mb-1"></i> Semua
                                        </label>
                                    </div>
                                    <div class="col-4">
                                        <input type="radio" class="btn-check" name="user_type" id="guru" value="guru">
                                        <label class="btn btn-outline-success w-100 py-3 fw-bold rounded-4" for="guru">
                                            <i class="bi bi-person-video3 d-block fs-4 mb-1"></i> Guru
                                        </label>
                                    </div>
                                    <div class="col-4">
                                        <input type="radio" class="btn-check" name="user_type" id="siswa" value="siswa">
                                        <label class="btn btn-outline-warning w-100 py-3 fw-bold rounded-4" for="siswa">
                                            <i class="bi bi-backpack-fill d-block fs-4 mb-1"></i> Siswa
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 mt-4">
                                <button type="submit" class="btn btn-print">
                                    <i class="bi bi-file-earmark-pdf-fill fs-5"></i> Generate Laporan PDF
                                </button>
                                <p class="text-center text-muted small mt-3 mb-0">
                                    <i class="bi bi-info-circle me-1"></i> Laporan akan dibuka di tab baru
                                </p>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>