<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-menu {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        background: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
    }

    .card-menu:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }

    .card-header-menu {
        padding: 20px;
        color: white;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .header-blue { background: linear-gradient(135deg, #435ebe 0%, #25396f 100%); }
    .header-green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
    .header-purple { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    .header-orange { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); }

    .nav-pills .nav-link {
        border-radius: 50px;
        padding: 12px 30px;
        font-weight: 600;
        color: #607080;
        background: #fff;
        border: 2px solid #eef2f7;
        margin-right: 10px;
        transition: all 0.3s;
    }

    .nav-pills .nav-link.active {
        background: #435ebe;
        color: #fff;
        border-color: #435ebe;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.3);
    }

    .form-control, .form-select {
        border-radius: 10px;
        padding: 10px 15px;
        border: 1px solid #eef2f7;
        background-color: #fcfcfc;
    }

    .form-control:focus, .form-select:focus {
        border-color: #435ebe;
        box-shadow: 0 0 0 4px rgba(67, 94, 190, 0.1);
    }

    .btn-print {
        border-radius: 10px;
        padding: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        width: 100%;
        margin-top: 10px;
    }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Pusat Laporan</h3>
            <p class="text-subtitle text-muted">Cetak laporan kehadiran Guru dan Siswa.</p>
        </div>
    </div>
</div>

<div class="page-content">
    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="pills-guru-tab" data-bs-toggle="pill" data-bs-target="#pills-guru" type="button">
                <i class="bi bi-person-video3 me-2"></i> Laporan Guru
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-siswa-tab" data-bs-toggle="pill" data-bs-target="#pills-siswa" type="button">
                <i class="bi bi-people-fill me-2"></i> Laporan Siswa
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-guru" role="tabpanel">
            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card card-menu h-100">
                        <div class="card-header-menu header-blue">
                            <i class="bi bi-list-check fs-4"></i> Detail Harian (Rentang Tanggal)
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/laporan/cetak-guru-detail') ?>" method="post" target="_blank">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Tanggal Awal</label>
                                    <input type="date" name="tgl_awal" class="form-control" required value="<?= date('Y-m-01') ?>">
                                </div>
                                <div class="mb-4">
                                    <label class="form-label fw-bold">Tanggal Akhir</label>
                                    <input type="date" name="tgl_akhir" class="form-control" required value="<?= date('Y-m-d') ?>">
                                </div>
                                <button type="submit" class="btn btn-primary btn-print shadow-sm">
                                    <i class="bi bi-printer-fill me-2"></i> Cetak Laporan
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-4">
                    <div class="card card-menu h-100">
                        <div class="card-header-menu header-purple">
                            <i class="bi bi-grid-3x3-gap-fill fs-4"></i> Rekap Matriks Bulanan
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/laporan/cetak-guru-rekap') ?>" method="post" target="_blank">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Pilih Bulan</label>
                                    <select name="bulan" class="form-select">
                                        <?php 
                                        $bln = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
                                        foreach($bln as $key => $b) : ?>
                                            <option value="<?= $key+1 ?>" <?= (date('n') == $key+1) ? 'selected' : '' ?>><?= $b ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-4">
                                    <label class="form-label fw-bold">Pilih Tahun</label>
                                    <select name="tahun" class="form-select">
                                        <?php for($y=date('Y'); $y>=2020; $y--) : ?>
                                            <option value="<?= $y ?>"><?= $y ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary btn-print shadow-sm" style="background: #667eea; border-color: #667eea;">
                                    <i class="bi bi-printer-fill me-2"></i> Cetak Matriks
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-siswa" role="tabpanel">
            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card card-menu h-100">
                        <div class="card-header-menu header-green">
                            <i class="bi bi-list-check fs-4"></i> Detail Harian (Rentang Tanggal)
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/laporan/cetak-siswa-detail') ?>" method="post" target="_blank">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Pilih Kelas</label>
                                    <select name="kelas_id" class="form-select" required>
                                        <option value="">-- Semua / Pilih Kelas --</option>
                                        <?php foreach($kelas as $k): ?>
                                            <option value="<?= $k['id'] ?>"><?= $k['nama_kelas'] ?> - <?= $k['jurusan'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label class="form-label fw-bold">Dari</label>
                                        <input type="date" name="tgl_awal" class="form-control" required value="<?= date('Y-m-01') ?>">
                                    </div>
                                    <div class="col-6 mb-4">
                                        <label class="form-label fw-bold">Sampai</label>
                                        <input type="date" name="tgl_akhir" class="form-control" required value="<?= date('Y-m-d') ?>">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success btn-print shadow-sm">
                                    <i class="bi bi-printer-fill me-2"></i> Cetak Laporan
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-4">
                    <div class="card card-menu h-100">
                        <div class="card-header-menu header-orange">
                            <i class="bi bi-grid-3x3-gap-fill fs-4"></i> Rekap Matriks Bulanan
                        </div>
                        <div class="card-body p-4">
                            <form action="<?= base_url('admin/laporan/cetak-siswa-rekap') ?>" method="post" target="_blank">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Pilih Kelas</label>
                                    <select name="kelas_id" class="form-select" required>
                                        <option value="">-- Pilih Kelas --</option>
                                        <?php foreach($kelas as $k): ?>
                                            <option value="<?= $k['id'] ?>"><?= $k['nama_kelas'] ?> - <?= $k['jurusan'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label class="form-label fw-bold">Bulan</label>
                                        <select name="bulan" class="form-select">
                                            <?php foreach($bln as $key => $b) : ?>
                                                <option value="<?= $key+1 ?>" <?= (date('n') == $key+1) ? 'selected' : '' ?>><?= $b ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-6 mb-4">
                                        <label class="form-label fw-bold">Tahun</label>
                                        <select name="tahun" class="form-select">
                                            <?php for($y=date('Y'); $y>=2020; $y--) : ?>
                                                <option value="<?= $y ?>"><?= $y ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-warning btn-print text-white shadow-sm" style="background: #fda085; border-color: #fda085;">
                                    <i class="bi bi-printer-fill me-2"></i> Cetak Matriks
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?= $this->endSection() ?>