<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    .card-modern { border: none; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); overflow: hidden; }
    .card-header-modern { background: linear-gradient(135deg, #ff5f6d 0%, #ffc371 100%); padding: 25px; color: white; display: flex; justify-content: space-between; align-items: center; }
    .btn-add-new { background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 12px; padding: 8px 20px; font-weight: 600; transition: all 0.3s; backdrop-filter: blur(5px); text-decoration: none; display: flex; align-items: center; gap: 8px; }
    .btn-add-new:hover { background: white; color: #ff5f6d; transform: translateY(-2px); }
    .table-modern thead th { background-color: #f8f9fa; color: #607080; border-bottom: 2px solid #eef2f7; padding: 15px; }
    .table-modern tbody td { padding: 15px; vertical-align: middle; border-bottom: 1px solid #f2f4f8; }
    .date-badge { background: #fff3cd; color: #ffc107; padding: 5px 10px; border-radius: 8px; font-weight: bold; font-size: 0.85rem; border: 1px solid #ffeeba; }
    .btn-delete { background: #fff0f0; color: #ff4c4c; border: none; padding: 8px 12px; border-radius: 8px; transition: all 0.3s; }
    .btn-delete:hover { background: #ff4c4c; color: white; }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Hari Libur Nasional</h3>
            <p class="text-subtitle text-muted">Kelola hari libur khusus (tanggal merah) agar tidak terhitung Alfa.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active" aria-current="page">Libur Nasional</li>
            </ol>
        </nav>
    </div>
</div>

<div class="page-content">
    <?php if (session()->getFlashdata('success')) : ?>
        <script>Swal.fire({icon: 'success', title: 'Berhasil', text: '<?= session()->getFlashdata('success') ?>', timer: 3000, showConfirmButton: false})</script>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')) : ?>
        <script>Swal.fire({icon: 'error', title: 'Gagal', text: '<?= session()->getFlashdata('error') ?>'})</script>
    <?php endif; ?>

    <div class="card card-modern">
        <div class="card-header-modern">
            <div class="d-flex align-items-center">
                <i class="bi bi-calendar-event-fill fs-3 me-3"></i>
                <div>
                    <h5 class="mb-0 text-white">Daftar Hari Libur</h5>
                    <small class="text-white text-opacity-75">Tanggal Spesifik</small>
                </div>
            </div>
            <a href="<?= base_url('admin/libur-nasional/new') ?>" class="btn-add-new">
                <i class="bi bi-plus-lg"></i> Tambah Libur
            </a>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive p-4">
                <table class="table table-modern">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>Nama Hari Libur</th>
                            <th>Tanggal Mulai</th>
                            <th>Tanggal Akhir</th>
                            <th>Durasi</th>
                            <th>Deskripsi</th>
                            <th width="10%" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($libur)): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">Belum ada data hari libur.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($libur as $key => $l) : 
                                $start = new DateTime($l['tanggal_mulai']);
                                $end = new DateTime($l['tanggal_akhir']);
                                $interval = $start->diff($end);
                                $durasi = $interval->days + 1; 
                            ?>
                            <tr>
                                <td><?= $key + 1 ?></td>
                                <td class="fw-bold"><?= esc($l['nama_libur']) ?></td>
                                <td><span class="date-badge"><?= date('d M Y', strtotime($l['tanggal_mulai'])) ?></span></td>
                                <td><span class="date-badge"><?= date('d M Y', strtotime($l['tanggal_akhir'])) ?></span></td>
                                <td><?= $durasi ?> Hari</td>
                                <td class="text-muted small"><?= esc($l['deskripsi']) ?></td>
                                <td class="text-center">
                                    <button onclick="confirmDelete(<?= $l['id'] ?>)" class="btn-delete" title="Hapus">
                                        <i class="bi bi-trash-fill"></i>
                                    </button>
                                    <form id="delete-form-<?= $l['id'] ?>" action="<?= base_url('admin/libur-nasional/delete/' . $l['id']) ?>" method="get" class="d-none"></form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Hapus Hari Libur?', text: "Data ini akan dihapus permanen.", icon: 'warning',
            showCancelButton: true, confirmButtonColor: '#ff4c4c', cancelButtonColor: '#8592a3', confirmButtonText: 'Ya, Hapus!'
        }).then((result) => { if (result.isConfirmed) document.getElementById('delete-form-' + id).submit(); })
    }
</script>
<?= $this->endSection() ?>