<?php
    $jam = date('H');
    if ($jam >= 5 && $jam < 11) {
        $sapaan = "Selamat Pagi";
        $iconSapaan = "bi-sun-fill text-warning";
    } elseif ($jam >= 11 && $jam < 15) {
        $sapaan = "Selamat Siang";
        $iconSapaan = "bi-brightness-high-fill text-warning";
    } elseif ($jam >= 15 && $jam < 18) {
        $sapaan = "Selamat Sore";
        $iconSapaan = "bi-sunset-fill text-warning";
    } else {
        $sapaan = "Selamat Malam";
        $iconSapaan = "bi-moon-stars-fill text-primary";
    }
    
    $hariIni = date('d F Y');
    $namaUser = strtok(session()->get('nama'), " ");
?>

<style>
    .navbar-glass {
        background: rgba(255, 255, 255, 0.7);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.4);
        border-radius: 20px;
        margin-bottom: 2rem;
        transition: all 0.4s ease;
        animation: slideDown 0.8s ease-out;
    }

    @keyframes slideDown {
        from { transform: translateY(-100%); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }

    .burger-btn i {
        color: #435ebe;
        transition: transform 0.3s;
    }
    .burger-btn:hover i {
        transform: scale(1.1);
    }

    .greeting-box {
        background: linear-gradient(135deg, #f6f7ff 0%, #e9eeff 100%);
        padding: 8px 20px;
        border-radius: 50px;
        border: 1px solid rgba(67, 94, 190, 0.1);
    }

    .btn-notif {
        position: relative;
        width: 45px;
        height: 45px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 12px;
        background: rgba(255, 255, 255, 0.5);
        color: #607080;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .btn-notif:hover {
        background: #fff;
        color: #435ebe;
        box-shadow: 0 5px 15px rgba(67, 94, 190, 0.15);
        transform: translateY(-2px);
    }

    .indicator-pulse {
        position: absolute;
        top: 10px;
        right: 12px;
        width: 8px;
        height: 8px;
        background: #ff5252;
        border-radius: 50%;
        box-shadow: 0 0 0 0 rgba(255, 82, 82, 0.7);
        animation: pulse-red 2s infinite;
    }

    @keyframes pulse-red {
        0% { transform: scale(0.95); box-shadow: 0 0 0 0 rgba(255, 82, 82, 0.7); }
        70% { transform: scale(1); box-shadow: 0 0 0 6px rgba(255, 82, 82, 0); }
        100% { transform: scale(0.95); box-shadow: 0 0 0 0 rgba(255, 82, 82, 0); }
    }

    .user-dropdown-toggle {
        padding: 5px;
        border-radius: 50px;
        transition: all 0.3s ease;
    }
    
    .user-dropdown-toggle:hover {
        background: rgba(255, 255, 255, 0.6);
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }

    .user-img img {
        width: 45px;
        height: 45px;
        object-fit: cover;
        border-radius: 50%;
        border: 3px solid #fff;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }

    .custom-dropdown-menu {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        margin-top: 15px !important;
        animation: fadeInUp 0.3s ease;
    }

    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .dropdown-item {
        padding: 10px 20px;
        border-radius: 8px;
        margin: 5px;
        width: auto;
        font-weight: 500;
        transition: all 0.2s;
    }

    .dropdown-item:hover {
        background: #f2f7ff;
        color: #435ebe;
        transform: translateX(5px);
    }

    .date-badge {
        font-size: 0.75rem;
        background: rgba(67, 94, 190, 0.1);
        color: #435ebe;
        padding: 4px 10px;
        border-radius: 20px;
        font-weight: 700;
        margin-left: 10px;
    }
</style>

<header class='mb-3'>
    <nav class="navbar navbar-expand navbar-light navbar-top navbar-glass px-4 py-3">
        <div class="container-fluid">
            <a href="#" class="burger-btn d-block me-4">
                <i class="bi bi-justify fs-3"></i>
            </a>

            <div class="d-none d-lg-flex align-items-center greeting-box">
                <i class="bi <?= $iconSapaan ?> fs-5 me-2"></i>
                <span class="text-gray-600">
                    <?= $sapaan ?>, <span class="fw-bold text-dark"><?= $namaUser ?></span>
                </span>
                <span class="date-badge">
                    <i class="bi bi-calendar-event me-1"></i> <?= $hariIni ?>
                </span>
            </div>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-center">

                    <li class="nav-item me-3">
                        <a href="<?= base_url('admin/help') ?>" class="nav-link btn-notif text-primary" title="Panduan Penggunaan">
                            <i class='bi bi-question-circle-fill fs-5'></i>
                        </a>
                    </li>

                    <li class="nav-item me-4">
                        <a class="nav-link btn-notif" href="#">
                            <i class='bi bi-bell fs-5'></i>
                            <span class="indicator-pulse"></span>
                        </a>
                    </li>
                </ul>

                <div class="dropdown">
                    <a href="#" data-bs-toggle="dropdown" aria-expanded="false" class="text-decoration-none">
                        <div class="user-menu d-flex align-items-center user-dropdown-toggle">
                            <div class="user-name text-end me-3 d-none d-md-block">
                                <h6 class="mb-0 text-gray-800 fw-bold"><?= session()->get('nama') ?? 'Guest User' ?></h6>
                                <p class="mb-0 text-xs text-secondary font-monospace"><?= strtoupper(session()->get('level') ?? 'GUEST') ?></p>
                            </div>
                            <div class="user-img d-flex align-items-center">
                                <div class="avatar">
                                    <?php 
                                        $foto = session()->get('foto') ? session()->get('foto') : 'default.jpg';
                                        $fotoPath = 'uploads/foto_profil/' . $foto;
                                    ?>
                                    <img src="<?= base_url($fotoPath) ?>" alt="Profil">
                                </div>
                            </div>
                        </div>
                    </a>
                    
                    <ul class="dropdown-menu dropdown-menu-end custom-dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <li>
                            <h6 class="dropdown-header text-gray-400 text-uppercase fs-7 ls-1">Account</h6>
                        </li>
                        
                        <?php if(session()->get('level') == 'admin'): ?>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="<?= base_url('admin/profil') ?>">
                                <i class="bi bi-person-circle me-3 text-primary"></i> Profil Saya
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="<?= base_url('admin/setting-gps') ?>">
                                <i class="bi bi-geo-alt-fill me-3 text-warning"></i> Lokasi Kantor
                            </a>
                        </li>
                        <?php endif; ?>

                        <li><hr class="dropdown-divider border-light"></li>
                        
                        <li>
                            <a class="dropdown-item d-flex align-items-center text-danger" href="<?= base_url('auth/logout') ?>">
                                <i class="bi bi-box-arrow-right me-3"></i> Log Out
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
</header>