<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Auth::index');

$routes->group('auth', function($routes) {
    $routes->get('/', 'Auth::index');
    $routes->post('process', 'Auth::process');
    $routes->get('logout', 'Auth::logout');
});

$routes->group('admin', ['filter' => 'auth:admin'], function($routes) {
    $routes->get('dashboard', 'Admin\Dashboard::index');

    $routes->get('cetak_kartu', 'Admin\CetakKartu::index');
    $routes->post('cetak_kartu/proses_guru', 'Admin\CetakKartu::prosesGuru');
    $routes->post('cetak-kartu/proses-guru', 'Admin\CetakKartu::prosesGuru');
    $routes->post('cetak_kartu/proses_siswa', 'Admin\CetakKartu::prosesSiswa');
    $routes->post('cetak-kartu/proses-siswa', 'Admin\CetakKartu::prosesSiswa');
    
    $routes->get('profil', 'Admin\Profil::index');
    $routes->post('profil/update', 'Admin\Profil::update');
    
    $routes->get('users', 'Admin\Users::index');
    $routes->get('users/new', 'Admin\Users::new');
    $routes->post('users/create', 'Admin\Users::create');
    $routes->get('users/edit/(:num)', 'Admin\Users::edit/$1');
    $routes->post('users/update/(:num)', 'Admin\Users::update/$1');
    $routes->get('users/delete/(:num)', 'Admin\Users::delete/$1');
    
    $routes->get('sekolah', 'Admin\Sekolah::index');
    $routes->post('sekolah/update', 'Admin\Sekolah::update');
    
    $routes->get('kelas', 'Admin\Kelas::index');
    $routes->get('kelas/new', 'Admin\Kelas::new');
    $routes->post('kelas/create', 'Admin\Kelas::create');
    $routes->get('kelas/edit/(:num)', 'Admin\Kelas::edit/$1');
    $routes->post('kelas/update/(:num)', 'Admin\Kelas::update/$1');
    $routes->get('kelas/delete/(:num)', 'Admin\Kelas::delete/$1');
    $routes->get('kelas/students/(:num)', 'Admin\Kelas::students/$1');
    $routes->get('kelas/download-qr/(:num)', 'Admin\Kelas::downloadQr/$1');
    
    $routes->get('guru', 'Admin\Guru::index');
    $routes->get('guru/new', 'Admin\Guru::new');
    $routes->post('guru/create', 'Admin\Guru::create');
    $routes->get('guru/edit/(:num)', 'Admin\Guru::edit/$1');
    $routes->post('guru/update/(:num)', 'Admin\Guru::update/$1');
    $routes->get('guru/delete/(:num)', 'Admin\Guru::delete/$1');
    $routes->get('guru/generate-qr/(:num)', 'Admin\Guru::generateQr/$1');
    $routes->get('guru/template', 'Admin\Guru::downloadTemplate');
    $routes->post('guru/import', 'Admin\Guru::import');
    
    $routes->get('siswa', 'Admin\Siswa::index');
    $routes->get('siswa/new', 'Admin\Siswa::new');
    $routes->post('siswa/create', 'Admin\Siswa::create');
    $routes->get('siswa/edit/(:num)', 'Admin\Siswa::edit/$1');
    $routes->post('siswa/update/(:num)', 'Admin\Siswa::update/$1');
    $routes->get('siswa/delete/(:num)', 'Admin\Siswa::delete/$1');
    $routes->get('siswa/generate-qr/(:num)', 'Admin\Siswa::generateQr/$1');
    $routes->get('siswa/template', 'Admin\Siswa::downloadTemplate');
    $routes->post('siswa/import', 'Admin\Siswa::import');
    
    $routes->get('setting-print', 'Admin\SettingPrint::index');
    $routes->post('setting-print/save', 'Admin\SettingPrint::save');
    
    $routes->get('setting-gps', 'Admin\SettingGps::index');
    $routes->post('setting-gps/save', 'Admin\SettingGps::save');

    $routes->get('setting-jam', 'Admin\SettingJam::index');
    $routes->post('setting-jam/update', 'Admin\SettingJam::update');

    $routes->get('setting-whatsapp', 'Admin\SettingWhatsapp::index');
    $routes->post('setting-whatsapp/save', 'Admin\SettingWhatsapp::save');

    $routes->get('setting-theme', 'Admin\SettingTheme::index');
    $routes->post('setting-theme/update', 'Admin\SettingTheme::update');

    $routes->get('libur-nasional', 'Admin\LiburNasional::index');
    $routes->get('setting-libur', 'Admin\LiburNasional::index');
    $routes->get('libur-nasional/new', 'Admin\LiburNasional::new');
    $routes->post('libur-nasional/create', 'Admin\LiburNasional::create');
    $routes->get('libur-nasional/delete/(:num)', 'Admin\LiburNasional::delete/$1');

    $routes->get('jadwal', 'Admin\Jadwal::index');
    $routes->post('jadwal/save-sholat', 'Admin\Jadwal::saveSholat');
    $routes->post('jadwal/update-sholat', 'Admin\Jadwal::updateSholat');
    $routes->get('jadwal/delete-sholat/(:num)', 'Admin\Jadwal::deleteSholat/$1');
    $routes->post('jadwal/save-ekskul', 'Admin\Jadwal::saveEkskul');
    $routes->post('jadwal/update-ekskul', 'Admin\Jadwal::updateEkskul');
    $routes->get('jadwal/delete-ekskul/(:num)', 'Admin\Jadwal::deleteEkskul/$1');
    
    $routes->get('laporan', 'Admin\Laporan::index');
    $routes->post('laporan/cetak-guru-detail', 'Admin\Laporan::cetakGuruDetail');
    $routes->post('laporan/cetak-guru-rekap', 'Admin\Laporan::cetakGuruRekap');
    $routes->post('laporan/cetak-siswa-detail', 'Admin\Laporan::cetakSiswaDetail');
    $routes->post('laporan/cetak-siswa-rekap', 'Admin\Laporan::cetakSiswaRekap');

    $routes->get('laporan-kegiatan', 'Admin\LaporanKegiatan::index');
    $routes->post('laporan-kegiatan/cetak', 'Admin\LaporanKegiatan::cetak');

    $routes->get('koreksi', 'Admin\Koreksi::index');
    $routes->get('koreksi/filter', 'Admin\Koreksi::filter');
    $routes->post('koreksi/bulkAction', 'Admin\Koreksi::bulkAction');
    $routes->get('koreksi/delete/(:num)', 'Admin\Koreksi::delete/$1');
    $routes->get('absensi/edit/(:num)', 'Admin\Absensi::edit/$1');
    $routes->post('absensi/update-manual', 'Admin\Absensi::updateManual');
    $routes->get('absensi/input', 'Admin\Absensi::input');
    $routes->post('absensi/save-manual', 'Admin\Absensi::saveManual');

    $routes->get('koreksi-kegiatan', 'Admin\LaporanKegiatan::koreksi');
    $routes->post('koreksi-kegiatan/save', 'Admin\LaporanKegiatan::saveKoreksi');
    $routes->get('koreksi-kegiatan/delete/(:num)', 'Admin\LaporanKegiatan::deleteKoreksi/$1');

    $routes->get('rekap-absensi', 'Petugas\DataAbsensi::index');

    $routes->get('whatsapp', 'Admin\Whatsapp::index');
    $routes->get('updater', 'Admin\Updater::index');
    $routes->get('updater/init', 'Admin\Updater::initUpdate');
    $routes->get('updater/extract', 'Admin\Updater::extractFiles');
    $routes->get('updater/status', 'Admin\Updater::checkStatus');

    $routes->get('help', 'Admin\Help::index');
});

$routes->group('petugas', ['filter' => 'auth:petugas'], function($routes) {
    $routes->get('dashboard', 'Petugas\Dashboard::index');
    $routes->get('data-absensi', 'Petugas\DataAbsensi::index');
});

$routes->group('absensi', ['filter' => 'auth'], function($routes) {
    $routes->get('scan', 'Absensi::scanPage');
    $routes->post('process-scan', 'Absensi::processScan');
});