<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\GuruModel;
use App\Models\SiswaModel;
use App\Models\AbsensiModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $guruModel = new GuruModel();
        $siswaModel = new SiswaModel();
        $absensiModel = new AbsensiModel();
        
        $tanggalHariIni = date('Y-m-d');

        $data = [
            'title' => 'Dashboard Admin',
            'total_guru' => $guruModel->countAllResults(),
            'total_siswa' => $siswaModel->countAllResults(),
            
            // Statistik Absensi Hari Ini
            'hadir_hari_ini' => $absensiModel->where('tanggal', $tanggalHariIni)
                                             ->where('status', 'Hadir')
                                             ->countAllResults(),
                                             
            'terlambat_hari_ini' => $absensiModel->where('tanggal', $tanggalHariIni)
                                                 ->where('status', 'Terlambat')
                                                 ->countAllResults(),
                                                 
            'cepat_pulang_hari_ini' => $absensiModel->where('tanggal', $tanggalHariIni)
                                                    ->where('status', 'Cepat Pulang')
                                                    ->countAllResults(),
                                                    
            'izin_sakit_hari_ini' => $absensiModel->where('tanggal', $tanggalHariIni)
                                                  ->groupStart()
                                                      ->where('status', 'Izin')
                                                      ->orWhere('status', 'Sakit')
                                                  ->groupEnd()
                                                  ->countAllResults(),
        ];

        return view('admin/dashboard', $data);
    }
}