<?php

namespace App\Controllers\Petugas;

use App\Controllers\BaseController;
use App\Models\AbsensiModel;
use App\Models\KelasModel;

class DataAbsensi extends BaseController
{
    public function index()
    {
        $absensiModel = new AbsensiModel();
        $kelasModel = new KelasModel();
        
        $tab = $this->request->getGet('tab') ?? 'guru';
        $tglAwal = $this->request->getGet('tgl_awal') ?? date('Y-m-d');
        $tglAkhir = $this->request->getGet('tgl_akhir') ?? date('Y-m-d');
        $kelasId = $this->request->getGet('kelas_id');

        $dataGuru = [];
        if ($tab == 'guru') {
            $dataGuru = $absensiModel->getLaporan($tglAwal, $tglAkhir, 'guru');
        }

        $dataSiswa = [];
        if ($tab == 'siswa') {
            $dataSiswa = $absensiModel->getLaporan($tglAwal, $tglAkhir, 'siswa', $kelasId);
        }

        $data = [
            'title' => 'Data Absensi Harian',
            'kelas' => $kelasModel->findAll(),
            'tab' => $tab,
            'tgl_awal' => $tglAwal,
            'tgl_akhir' => $tglAkhir,
            'kelas_id' => $kelasId,
            'absensi_guru' => $dataGuru,
            'absensi_siswa' => $dataSiswa
        ];

        return view('petugas/data_absensi/index', $data);
    }
}