<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>

<style>
.glass-card {
    background: #ffffff;
    border-radius: 15px;
    border: 1px solid #e2e8f0;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.card-preview-wrapper {
    width: 100%;
    display: flex;
    justify-content: center;
    padding: 20px 0;
}

.card-preview-container {
    width: 100%;
    max-width: 450px;
    aspect-ratio: 1011 / 638;
    border-radius: 8px;
    position: relative;
    overflow: hidden;
    display: flex;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
}

.desain-1-guru { background: linear-gradient(to right, #0f172a, #2e4a8a); color: white; }
.desain-1-siswa { background: linear-gradient(to right, #450a0a, #951414); color: white; }

.desain-2-guru, .desain-2-siswa { background: #ffffff; color: #1f2937; border: 1px solid #ddd; }
.desain-2-guru::before { content: ''; position: absolute; left: 0; top: 0; bottom: 0; width: 4%; background: #1e3a8a; }
.desain-2-siswa::before { content: ''; position: absolute; left: 0; top: 0; bottom: 0; width: 4%; background: #991b1b; }

.desain-3-guru { background: linear-gradient(to right, #3b82f6, #1e40af); color: white; }
.desain-3-siswa { background: linear-gradient(to right, #dc2626, #991b1b); color: white; }

.desain-4-guru { background: #0f172a; color: white; }
.desain-4-siswa { background: #450a0a; color: white; }
.desain-4-guru::after, .desain-4-siswa::after {
    content: ''; position: absolute; inset: 0; opacity: 0.1;
    background-image: repeating-linear-gradient(45deg, #fff, #fff 1px, transparent 1px, transparent 20px);
    pointer-events: none;
}

.photo-box {
    position: absolute;
    left: 8.4%;
    top: 27.4%;
    width: 27.7%;
    height: 43.8%;
    background: white;
    padding: 3px;
    box-shadow: 0 0 10px rgba(0,0,0,0.2);
    z-index: 2;
}
.photo-box img { width: 100%; height: 100%; object-fit: cover; }

.info-box {
    position: absolute;
    left: 42.5%;
    top: 15%;
    width: 53%;
    text-align: left;
    z-index: 2;
}
.info-box .school { font-weight: 800; font-size: 1.1rem; margin-bottom: 20%; text-transform: uppercase; }
.info-box .name { font-weight: 900; font-size: 1.3rem; line-height: 1.1; text-transform: uppercase; margin-bottom: 5px; }
.info-box .sub { font-size: 0.85rem; opacity: 0.9; margin-bottom: 2px; }
.info-box .id-num { font-size: 0.75rem; opacity: 0.8; }

.qr-box {
    position: absolute;
    right: 8%;
    bottom: 11%;
    width: 17.8%;
    height: 28.2%;
    background: white;
    padding: 5px;
    border-radius: 4px;
    z-index: 2;
}
.qr-box img { width: 100%; height: 100%; }

.btn-modern { border-radius: 10px; padding: 12px; font-weight: 700; }
.form-select-modern { border-radius: 10px; padding: 10px; border: 1px solid #cbd5e1; }
</style>

<div class="container-fluid py-4">
    <div class="row g-4 justify-content-center">
        <!-- Preview Guru -->
        <div class="col-md-6 col-xl-5">
            <div class="glass-card p-4">
                <h5 class="fw-bold mb-3 text-center">Kartu Guru</h5>
                <div class="card-preview-wrapper">
                    <div id="previewGuru" class="card-preview-container desain-1-guru">
                        <div class="photo-box"><img src="<?= base_url('assets/static/images/faces/1.jpg') ?>"></div>
                        <div class="info-box">
                            <div class="school"><?= $sekolah['nama_sekolah'] ?? 'SMK NEGERI INDONESIA' ?></div>
                            <div class="name">GURU SAMPLE, S.Pd</div>
                            <div class="sub">Staff & Pengajar</div>
                            <div class="id-num">NIP: 19880214201503</div>
                        </div>
                        <div class="qr-box"><img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=GURU"></div>
                    </div>
                </div>
                <form action="<?= base_url('admin/cetak-kartu/proses-guru') ?>" method="post" class="mt-2">
                    <?= csrf_field() ?>
                    <label class="small fw-bold mb-1">Pilih Desain:</label>
                    <select name="desain_id" class="form-select form-select-modern mb-3" onchange="updatePreview('guru', this.value)">
                        <option value="1">Desain 1: Modern Dark</option>
                        <option value="2">Desain 2: Minimalist Clean</option>
                        <option value="3">Desain 3: Vibrant Gradient</option>
                        <option value="4">Desain 4: Geometric Tech</option>
                    </select>
                    <button type="submit" class="btn btn-primary btn-modern w-100">Cetak Semua Kartu Guru</button>
                </form>
            </div>
        </div>

        <!-- Preview Siswa -->
        <div class="col-md-6 col-xl-5">
            <div class="glass-card p-4">
                <h5 class="fw-bold mb-3 text-center">Kartu Siswa</h5>
                <div class="card-preview-wrapper">
                    <div id="previewSiswa" class="card-preview-container desain-1-siswa">
                        <div class="photo-box"><img src="<?= base_url('assets/static/images/faces/2.jpg') ?>"></div>
                        <div class="info-box">
                            <div class="school"><?= $sekolah['nama_sekolah'] ?? 'SMK NEGERI INDONESIA' ?></div>
                            <div class="name">SISWA SAMPLE</div>
                            <div class="sub">XI RPL 1 - Informatika</div>
                            <div class="id-num">NISN: 0087654321</div>
                        </div>
                        <div class="qr-box"><img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=SISWA"></div>
                    </div>
                </div>
                <form action="<?= base_url('admin/cetak-kartu/proses-siswa') ?>" method="post" class="mt-2">
                    <?= csrf_field() ?>
                    <label class="small fw-bold mb-1">Pilih Kelas:</label>
                    <select name="kelas_id" class="form-select form-select-modern mb-2" required>
                        <option value="" disabled selected>-- Pilih Kelas --</option>
                        <?php foreach ($kelas as $k) : ?>
                            <option value="<?= $k['id'] ?>"><?= $k['nama_kelas'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <label class="small fw-bold mb-1">Pilih Desain:</label>
                    <select name="desain_id" class="form-select form-select-modern mb-3" onchange="updatePreview('siswa', this.value)">
                        <option value="1">Desain 1: Modern Dark</option>
                        <option value="2">Desain 2: Minimalist Clean</option>
                        <option value="3">Desain 3: Vibrant Gradient</option>
                        <option value="4">Desain 4: Geometric Tech</option>
                    </select>
                    <button type="submit" class="btn btn-danger btn-modern w-100">Cetak Per Kelas</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function updatePreview(type, dId) {
    const el = document.getElementById(type === 'guru' ? 'previewGuru' : 'previewSiswa');
    el.className = 'card-preview-container desain-' + dId + '-' + type;
}
</script>

<?= $this->endSection() ?>