<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-stat {
        border: none;
        border-radius: 20px;
        transition: all 0.3s ease;
        overflow: hidden;
        position: relative;
        min-height: 140px;
    }
    
    .card-stat:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }

    .card-stat .bg-shape {
        position: absolute;
        width: 120px;
        height: 120px;
        border-radius: 50%;
        background: rgba(255,255,255,0.15);
        right: -30px;
        top: -30px;
        z-index: 1;
    }

    .card-stat .bg-shape-2 {
        position: absolute;
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: rgba(255,255,255,0.1);
        right: 40px;
        bottom: -40px;
        z-index: 1;
    }

    .stat-content {
        position: relative;
        z-index: 2;
        color: white;
    }

    .stat-icon-wrapper {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(5px);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 1rem;
    }

    /* Gradients */
    .bg-gradient-purple { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    .bg-gradient-blue { background: linear-gradient(135deg, #2af598 0%, #009efd 100%); }
    .bg-gradient-green { background: linear-gradient(135deg, #0ba360 0%, #3cba92 100%); }
    .bg-gradient-red { background: linear-gradient(135deg, #ff512f 0%, #dd2476 100%); }
    .bg-gradient-orange { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #a18cd1 0%, #fbc2eb 100%); }

    .welcome-card {
        background: #fff;
        border-radius: 20px;
        border: none;
        position: relative;
        overflow: hidden;
    }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1">Dashboard Overview</h3>
            <p class="text-subtitle text-muted">Ringkasan statistik hari ini, <?= date('d F Y') ?></p>
        </div>
        <div class="d-none d-md-block">
            <a href="<?= base_url('absensi/scan') ?>" class="btn btn-primary shadow-sm">
                <i class="bi bi-qr-code-scan me-2"></i> Buka Scanner
            </a>
        </div>
    </div>
</div>

<div class="page-content">
    <section class="row">
        <div class="col-12 mb-4">
            <div class="card welcome-card p-4 shadow-sm">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <span class="badge bg-light-primary text-primary mb-2">Selamat Datang</span>
                        <h4 class="fw-bold text-dark">Halo, <?= session()->get('nama') ?>! 👋</h4>
                        <p class="text-muted mb-4">Selamat datang kembali di panel Admin. Pantau aktivitas absensi guru dan siswa secara real-time hari ini.</p>
                        <div class="d-flex gap-3">
                            <div class="d-flex align-items-center">
                                <div class="width-10 height-10 rounded-circle bg-success me-2"></div>
                                <small class="text-muted">Sistem Online</small>
                            </div>
                            <div class="d-flex align-items-center">
                                <div class="width-10 height-10 rounded-circle bg-primary me-2"></div>
                                <small class="text-muted">GPS Aktif</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 d-none d-md-block text-end position-relative">
                       <i class="bi bi-bar-chart-line-fill text-light-primary" style="font-size: 8rem; opacity: 0.1;"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Baris 1: Data Master -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-purple">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="stat-icon-wrapper"><i class="bi bi-person-video3 fs-4"></i></div>
                        </div>
                        <h6 class="text-white opacity-75 mb-0">Total Guru</h6>
                        <h2 class="font-bold text-white mb-0 mt-2"><?= $total_guru ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-blue">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="stat-icon-wrapper"><i class="bi bi-people-fill fs-4"></i></div>
                        </div>
                        <h6 class="text-white opacity-75 mb-0">Total Siswa</h6>
                        <h2 class="font-bold text-white mb-0 mt-2"><?= $total_siswa ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Hadir -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-green">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="stat-icon-wrapper"><i class="bi bi-check-circle-fill fs-4"></i></div>
                        </div>
                        <h6 class="text-white opacity-75 mb-0">Hadir Hari Ini</h6>
                        <h2 class="font-bold text-white mb-0 mt-2"><?= $hadir_hari_ini ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Izin/Sakit -->
        <div class="col-6 col-md-6 col-lg-3">
            <div class="card card-stat bg-gradient-info">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="stat-icon-wrapper"><i class="bi bi-file-medical-fill fs-4"></i></div>
                        </div>
                        <h6 class="text-white opacity-75 mb-0">Izin / Sakit</h6>
                        <h2 class="font-bold text-white mb-0 mt-2"><?= $izin_sakit_hari_ini ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Baris 2: Isu Absensi (Terlambat & Cepat Pulang) -->
        <div class="col-6 col-md-6 col-lg-6">
            <div class="card card-stat bg-gradient-red">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white opacity-75 mb-1">Terlambat</h6>
                            <h2 class="font-bold text-white mb-0"><?= $terlambat_hari_ini ?></h2>
                        </div>
                        <div class="stat-icon-wrapper mb-0 bg-white bg-opacity-25">
                            <i class="bi bi-alarm-fill fs-3"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-6 col-lg-6">
            <div class="card card-stat bg-gradient-orange">
                <div class="card-body px-4 py-4">
                    <div class="bg-shape"></div>
                    <div class="bg-shape-2"></div>
                    <div class="stat-content d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white opacity-75 mb-1">Cepat Pulang</h6>
                            <h2 class="font-bold text-white mb-0"><?= $cepat_pulang_hari_ini ?></h2>
                        </div>
                        <div class="stat-icon-wrapper mb-0 bg-white bg-opacity-25">
                            <i class="bi bi-box-arrow-left fs-3"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Akses Cepat (Sama seperti sebelumnya) -->
    <section class="row mt-2">
        <div class="col-12 col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title mb-0 text-dark">Akses Cepat</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3 col-6">
                            <a href="<?= base_url('admin/siswa/new') ?>" class="btn btn-outline-primary w-100 h-100 py-3 d-flex flex-column align-items-center gap-2 border-2">
                                <i class="bi bi-person-plus-fill fs-3"></i>
                                <span>Tambah Siswa</span>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?= base_url('admin/guru/new') ?>" class="btn btn-outline-success w-100 h-100 py-3 d-flex flex-column align-items-center gap-2 border-2">
                                <i class="bi bi-person-video2 fs-3"></i>
                                <span>Tambah Guru</span>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?= base_url('admin/laporan') ?>" class="btn btn-outline-warning w-100 h-100 py-3 d-flex flex-column align-items-center gap-2 border-2">
                                <i class="bi bi-printer-fill fs-3"></i>
                                <span>Cetak Laporan</span>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?= base_url('admin/setting-jam') ?>" class="btn btn-outline-danger w-100 h-100 py-3 d-flex flex-column align-items-center gap-2 border-2">
                                <i class="bi bi-clock-history fs-3"></i>
                                <span>Setting Jam</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white py-3">
                    <h5 class="card-title mb-0 text-dark">Info Server</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="text-muted"><i class="bi bi-clock me-2"></i> Waktu Server</span>
                            <span class="fw-bold"><?= date('H:i') ?> WIB</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="text-muted"><i class="bi bi-calendar-event me-2"></i> Tanggal</span>
                            <span class="fw-bold"><?= date('d M Y') ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="text-muted"><i class="bi bi-hdd-network me-2"></i> Versi App</span>
                            <span class="badge bg-light-secondary text-secondary">v1.1.0</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
</div>
<?= $this->endSection() ?>