<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-form { border: none; border-radius: 20px; box-shadow: 0 10px 40px rgba(0,0,0,0.05); overflow: hidden; background: #fff; }
    .card-header-gradient { background: linear-gradient(135deg, #ff5f6d 0%, #ffc371 100%); padding: 30px; color: white; position: relative; }
    .form-control-modern { border: 2px solid #eef2f7; border-radius: 12px; padding: 12px 15px; font-weight: 500; }
    .form-control-modern:focus { border-color: #ffc371; box-shadow: 0 5px 15px rgba(255, 195, 113, 0.1); }
    .btn-save { background: linear-gradient(90deg, #ff5f6d, #ffc371); border: none; border-radius: 12px; padding: 12px 30px; font-weight: 600; color: white; transition: all 0.3s; }
    .btn-save:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(255, 95, 109, 0.4); color: white; }
    .btn-cancel { background: #f1f3f5; color: #6c757d; border: none; border-radius: 12px; padding: 12px 30px; font-weight: 600; }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Tambah Hari Libur</h3>
            <p class="text-subtitle text-muted">Input tanggal libur nasional atau cuti bersama.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/libur-nasional') ?>">Libur Nasional</a></li>
                <li class="breadcrumb-item active" aria-current="page">Tambah</li>
            </ol>
        </nav>
    </div>
</div>

<div class="page-content">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card card-form">
                <div class="card-header-gradient">
                    <h5 class="mb-0 text-white fw-bold"><i class="bi bi-calendar-plus me-2"></i> Form Libur</h5>
                </div>
                <div class="card-body p-4 p-md-5">
                    <form action="<?= base_url('admin/libur-nasional/create') ?>" method="post">
                        <?= csrf_field() ?>

                        <div class="mb-3">
                            <label class="fw-bold mb-2">Nama Hari Libur <span class="text-danger">*</span></label>
                            <input type="text" name="nama_libur" class="form-control form-control-modern" placeholder="Contoh: Idul Fitri 1446H" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="fw-bold mb-2">Tanggal Mulai <span class="text-danger">*</span></label>
                                <input type="date" name="tanggal_mulai" id="tgl_mulai" class="form-control form-control-modern" required onchange="syncDate()">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="fw-bold mb-2">Tanggal Akhir <span class="text-danger">*</span></label>
                                <input type="date" name="tanggal_akhir" id="tgl_akhir" class="form-control form-control-modern" required>
                                <small class="text-muted d-block mt-1" style="font-size: 0.75rem;">*Sama dengan tanggal mulai jika hanya 1 hari.</small>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="fw-bold mb-2">Deskripsi (Opsional)</label>
                            <textarea name="deskripsi" class="form-control form-control-modern" rows="3" placeholder="Keterangan tambahan..."></textarea>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?= base_url('admin/libur-nasional') ?>" class="btn btn-cancel">Batal</a>
                            <button type="submit" class="btn btn-save">Simpan Data</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function syncDate() {
        // Jika tanggal akhir masih kosong, isi otomatis sama dengan tanggal mulai
        let start = document.getElementById('tgl_mulai').value;
        let end = document.getElementById('tgl_akhir');
        if (end.value === '') {
            end.value = start;
        }
    }
</script>
<?= $this->endSection() ?>