<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-settings { border: none; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); overflow: hidden; }
    .nav-pills .nav-link { border-radius: 50px; padding: 10px 25px; font-weight: 600; margin-right: 10px; border: 1px solid #eef2f7; color: #607080; background: #fff; }
    .nav-pills .nav-link.active { background: #435ebe; color: #fff; border-color: #435ebe; box-shadow: 0 4px 10px rgba(67, 94, 190, 0.3); }
    .table-input td { padding: 10px 5px; vertical-align: middle; }
    .form-control-sm { border-radius: 8px; border: 1px solid #dce1e6; text-align: center; font-weight: 500; }
    .form-control-sm:focus { border-color: #435ebe; box-shadow: none; background: #fbfdff; }
    .day-badge { display: block; font-weight: bold; color: #435ebe; margin-bottom: 2px; }
    .btn-save-float { position: fixed; bottom: 30px; right: 30px; z-index: 1000; padding: 15px 25px; border-radius: 50px; font-weight: bold; box-shadow: 0 10px 30px rgba(67, 94, 190, 0.4); animation: slideUp 0.5s ease-out; }
    @keyframes slideUp { from { transform: translateY(100px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }
</style>

<div class="page-heading mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Setting Jam Absensi</h3>
            <p class="text-subtitle text-muted">Atur jadwal jam masuk dan pulang untuk setiap hari.</p>
        </div>
    </div>
</div>

<div class="page-content">
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <form action="<?= base_url('admin/setting-jam/update') ?>" method="post">
        <?= csrf_field() ?>

        <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="pills-guru-tab" data-bs-toggle="pill" data-bs-target="#pills-guru" type="button">
                    <i class="bi bi-person-video3 me-2"></i> Jadwal Guru
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-siswa-tab" data-bs-toggle="pill" data-bs-target="#pills-siswa" type="button">
                    <i class="bi bi-backpack me-2"></i> Jadwal Siswa
                </button>
            </li>
        </ul>

        <div class="tab-content" id="pills-tabContent">
            
            <!-- TAB GURU -->
            <div class="tab-pane fade show active" id="pills-guru" role="tabpanel">
                <div class="card card-settings">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0 align-middle text-center table-input">
                                <thead class="bg-light">
                                    <tr>
                                        <th width="15%" class="text-start ps-4">Hari</th>
                                        <th width="20%">Mulai Masuk</th>
                                        <th width="20%">Batas Terlambat</th>
                                        <th width="20%">Mulai Pulang</th>
                                        <th width="20%">Akhir Absen</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($urutanHari as $hari) : 
                                        $row = isset($guru_settings[$hari]) ? $guru_settings[$hari] : null;
                                        if (!$row) continue; 
                                    ?>
                                    <tr>
                                        <td class="text-start ps-4">
                                            <span class="day-badge"><?= $hari ?></span>
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-success" 
                                                name="settings[<?= $row['id'] ?>][jam_masuk_mulai]" value="<?= $row['jam_masuk_mulai'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-danger" 
                                                name="settings[<?= $row['id'] ?>][jam_masuk_akhir]" value="<?= $row['jam_masuk_akhir'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-warning" 
                                                name="settings[<?= $row['id'] ?>][jam_pulang_mulai]" value="<?= $row['jam_pulang_mulai'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-primary" 
                                                name="settings[<?= $row['id'] ?>][jam_pulang_akhir]" value="<?= $row['jam_pulang_akhir'] ?>">
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB SISWA -->
            <div class="tab-pane fade" id="pills-siswa" role="tabpanel">
                <div class="card card-settings">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0 align-middle text-center table-input">
                                <thead class="bg-light">
                                    <tr>
                                        <th width="15%" class="text-start ps-4">Hari</th>
                                        <th width="20%">Mulai Masuk</th>
                                        <th width="20%">Batas Terlambat</th>
                                        <th width="20%">Mulai Pulang</th>
                                        <th width="20%">Akhir Absen</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($urutanHari as $hari) : 
                                        $row = isset($siswa_settings[$hari]) ? $siswa_settings[$hari] : null;
                                        if (!$row) continue; 
                                    ?>
                                    <tr>
                                        <td class="text-start ps-4">
                                            <span class="day-badge"><?= $hari ?></span>
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-success" 
                                                name="settings[<?= $row['id'] ?>][jam_masuk_mulai]" value="<?= $row['jam_masuk_mulai'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-danger" 
                                                name="settings[<?= $row['id'] ?>][jam_masuk_akhir]" value="<?= $row['jam_masuk_akhir'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-warning" 
                                                name="settings[<?= $row['id'] ?>][jam_pulang_mulai]" value="<?= $row['jam_pulang_mulai'] ?>">
                                        </td>
                                        <td>
                                            <input type="time" class="form-control form-control-sm text-primary" 
                                                name="settings[<?= $row['id'] ?>][jam_pulang_akhir]" value="<?= $row['jam_pulang_akhir'] ?>">
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <button type="submit" class="btn btn-primary btn-save-float">
            <i class="bi bi-save2-fill me-2"></i> Simpan Semua Perubahan
        </button>
    </form>
</div>
<?= $this->endSection() ?>