<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<style>
    .card-settings {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.05);
        overflow: hidden;
        background: #fff;
    }

    .card-header-gradient {
        background: linear-gradient(135deg, #435ebe 0%, #25396f 100%);
        padding: 40px 30px;
        color: white;
        position: relative;
    }

    .card-header-gradient::before {
        content: '';
        position: absolute;
        top: -30px;
        right: -30px;
        width: 150px;
        height: 150px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }

    .card-header-gradient::after {
        content: '';
        position: absolute;
        bottom: 20px;
        left: 20px;
        width: 60px;
        height: 60px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }

    .day-card {
        border: 2px solid #eef2f7;
        border-radius: 15px;
        padding: 20px;
        transition: all 0.3s ease;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        background: #fff;
        height: 100%;
        position: relative;
        overflow: hidden;
    }

    .day-card:hover {
        border-color: #435ebe;
        background: #fbfbfc;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }

    .day-card.active-day {
        border-color: #435ebe;
        background: #f0f3ff;
    }
    
    .day-card.active-day::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 5px;
        background: #435ebe;
    }

    .day-label {
        font-weight: 700;
        font-size: 1.1rem;
        color: #555;
        margin-left: 10px;
    }

    .active-day .day-label {
        color: #435ebe;
    }

    .form-check-input {
        width: 3.5em;
        height: 1.75em;
        cursor: pointer;
        background-color: #e9ecef;
        border-color: #dee2e6;
    }

    .form-check-input:checked {
        background-color: #435ebe;
        border-color: #435ebe;
    }

    .btn-save {
        background: linear-gradient(90deg, #435ebe, #25396f);
        border: none;
        border-radius: 12px;
        padding: 15px 30px;
        font-weight: 600;
        font-size: 1rem;
        box-shadow: 0 4px 15px rgba(67, 94, 190, 0.3);
        transition: all 0.3s;
        color: white;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 94, 190, 0.4);
        color: white;
    }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Konfigurasi Laporan</h3>
            <p class="text-subtitle text-muted">Pilih hari kerja yang akan ditampilkan pada laporan cetak.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active" aria-current="page">Setting Print</li>
            </ol>
        </nav>
    </div>
</div>

<div class="page-content">
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
            <i class="bi bi-check-circle-fill me-2"></i>
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row justify-content-center">
        <div class="col-12 col-md-10 col-lg-8">
            <div class="card card-settings">
                <div class="card-header-gradient text-center">
                    <div class="d-inline-block p-3 rounded-circle bg-white bg-opacity-25 mb-3">
                        <i class="bi bi-calendar-week-fill fs-1 text-white"></i>
                    </div>
                    <h4 class="text-white fw-bold mb-2">Hari Kerja Efektif</h4>
                    <p class="text-white text-opacity-75 mb-0">Nonaktifkan hari libur agar tidak muncul di kolom absensi.</p>
                </div>

                <div class="card-body p-4 p-md-5">
                    <form action="<?= base_url('admin/setting-print/save') ?>" method="post">
                        <?= csrf_field() ?>
                        
                        <div class="row g-3">
                            <?php foreach ($hari as $h) : ?>
                            <div class="col-12 col-md-6">
                                <label class="day-card <?= $h['tampilkan'] == 1 ? 'active-day' : '' ?>" for="hari_<?= $h['id'] ?>">
                                    <div class="d-flex align-items-center">
                                        <div class="icon-wrapper">
                                            <?php 
                                                $icon = 'bi-calendar-day';
                                                if ($h['nama_hari'] == 'Minggu') $icon = 'bi-sun-fill text-danger';
                                                else if ($h['nama_hari'] == 'Jumat') $icon = 'bi-moon-stars-fill text-warning';
                                            ?>
                                            <i class="bi <?= $icon ?> fs-4 opacity-50"></i>
                                        </div>
                                        <span class="day-label"><?= $h['nama_hari'] ?></span>
                                    </div>
                                    <div class="form-check form-switch m-0">
                                        <input class="form-check-input" type="checkbox" id="hari_<?= $h['id'] ?>" name="hari_id[]" value="<?= $h['id'] ?>" <?= $h['tampilkan'] == 1 ? 'checked' : '' ?> onchange="toggleCard(this)">
                                    </div>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="mt-5">
                            <button type="submit" class="btn btn-save">
                                <i class="bi bi-save-fill"></i> Simpan Pengaturan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleCard(checkbox) {
        const card = checkbox.closest('.day-card');
        if (checkbox.checked) {
            card.classList.add('active-day');
        } else {
            card.classList.remove('active-day');
        }
    }
</script>

<?= $this->endSection() ?>