<?= $this->extend('layout/template') ?>

<?= $this->section('content') ?>
<link rel="stylesheet" href="<?= base_url('assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/compiled/css/table-datatable-jquery.css') ?>">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    .card-modern {
        border: none;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        overflow: hidden;
        background: #fff;
    }

    .card-header-modern {
        background: linear-gradient(135deg, #435ebe 0%, #25396f 100%);
        padding: 25px;
        color: white;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .table-modern thead th {
        background-color: #f8f9fa;
        color: #607080;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 0.85rem;
        border-bottom: 2px solid #eef2f7;
        padding: 15px;
        white-space: nowrap;
    }

    .table-modern tbody td {
        padding: 15px;
        vertical-align: middle;
        color: #555;
        border-bottom: 1px solid #f2f4f8;
        font-size: 0.95rem;
    }

    .table-modern tbody tr:hover {
        background-color: #fcfdff;
    }

    .user-info-cell {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        background: #eef2ff;
        color: #435ebe;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 1.1rem;
    }

    .user-details h6 {
        margin: 0;
        font-weight: 700;
        color: #333;
        font-size: 0.95rem;
    }

    .user-details span {
        font-size: 0.8rem;
        color: #888;
    }

    .status-badge {
        padding: 6px 12px;
        border-radius: 30px;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        display: inline-block;
        min-width: 80px;
        text-align: center;
    }

    .status-hadir { background: #d1e7dd; color: #198754; }
    .status-terlambat { background: #f8d7da; color: #dc3545; }
    .status-sakit { background: #cff4fc; color: #0dcaf0; }
    .status-izin { background: #fff3cd; color: #ffc107; }
    .status-alfa { background: #e2e3e5; color: #383d41; }
    .status-cepat-pulang { background: #fff3cd; color: #d39e00; }

    .time-badge {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        padding: 4px 10px;
        border-radius: 8px;
        font-family: 'Courier New', Courier, monospace;
        font-weight: 600;
        color: #495057;
        font-size: 0.85rem;
    }

    .nav-tabs .nav-link { 
        border-radius: 10px 10px 0 0; 
        color: #ffffff; 
        font-weight: 600; 
        background: rgba(255,255,255,0.1);
        border: none;
        margin-right: 5px;
    }
    
    .nav-tabs .nav-link:hover {
        background: rgba(255,255,255,0.2);
        color: white;
    }

    .nav-tabs .nav-link.active { 
        color: #435ebe; 
        background: #fff;
        border-bottom: none; 
    }
</style>

<div class="page-heading">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="mb-1 text-primary fw-bold">Data Absensi</h3>
            <p class="text-subtitle text-muted">Rekapitulasi kehadiran guru dan siswa.</p>
        </div>
    </div>
</div>

<div class="page-content">
    <div class="card card-modern">
        <div class="card-header-modern" style="padding: 15px 25px 0 25px; display: block;">
            
            <ul class="nav nav-tabs border-0" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link <?= $tab == 'guru' ? 'active' : '' ?>" href="<?= base_url('petugas/data-absensi?tab=guru') ?>">
                        <i class="bi bi-person-video3 me-2"></i> Data Guru
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $tab == 'siswa' ? 'active' : '' ?>" href="<?= base_url('petugas/data-absensi?tab=siswa') ?>">
                        <i class="bi bi-people-fill me-2"></i> Data Siswa
                    </a>
                </li>
            </ul>

        </div>
        
        <div class="card-body p-4">
            
            <form method="get" action="">
                <input type="hidden" name="tab" value="<?= $tab ?>">
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label class="fw-bold mb-1 small">Dari Tanggal</label>
                        <input type="date" name="tgl_awal" class="form-control" value="<?= $tgl_awal ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="fw-bold mb-1 small">Sampai Tanggal</label>
                        <input type="date" name="tgl_akhir" class="form-control" value="<?= $tgl_akhir ?>">
                    </div>
                    <?php if($tab == 'siswa'): ?>
                    <div class="col-md-3">
                        <label class="fw-bold mb-1 small">Kelas</label>
                        <select name="kelas_id" class="form-select">
                            <option value="">Semua Kelas</option>
                            <?php foreach($kelas as $k): ?>
                                <option value="<?= $k['id'] ?>" <?= $kelas_id == $k['id'] ? 'selected' : '' ?>><?= $k['nama_kelas'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-3 align-self-end">
                        <button type="submit" class="btn btn-primary w-100 fw-bold"><i class="bi bi-filter me-2"></i> Filter Data</button>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-modern" id="table1">
                    <thead>
                        <tr>
                            <th>Waktu Absen</th>
                            <th>Nama Pengguna</th>
                            <?php if($tab=='siswa'): ?><th>Kelas</th><?php endif; ?>
                            <th>Masuk</th>
                            <th>Pulang</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $data = ($tab == 'guru') ? $absensi_guru : $absensi_siswa;
                        if(empty($data)): ?>
                            <tr><td colspan="<?= ($tab=='siswa') ? '6' : '5' ?>" class="text-center py-4 text-muted">Tidak ada data absensi.</td></tr>
                        <?php else:
                            foreach($data as $row): 
                                $nama = $row['nama_lengkap'];
                                $nomor = $row['nomor_induk'];
                        ?>
                        <tr>
                            <td>
                                <span class="fw-bold text-dark"><?= date('d M Y', strtotime($row['tanggal'])) ?></span>
                            </td>
                            <td>
                                <div class="user-info-cell">
                                    <div class="user-avatar"><?= substr($nama, 0, 1) ?></div>
                                    <div class="user-details">
                                        <h6><?= $nama ?></h6>
                                        <span><?= $nomor ?></span>
                                    </div>
                                </div>
                            </td>
                            <?php if($tab=='siswa'): ?><td><span class="badge bg-light text-dark border"><?= isset($row['nama_kelas']) ? $row['nama_kelas'] : '-' ?></span></td><?php endif; ?>
                            <td>
                                <?php if($row['jam_masuk'] && $row['jam_masuk'] != '-'): ?>
                                    <span class="time-badge text-success"><?= $row['jam_masuk'] ?></span>
                                <?php else: ?>
                                    <span class="text-muted small">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($row['jam_pulang'] && $row['jam_pulang'] != '-'): ?>
                                    <span class="time-badge text-primary"><?= $row['jam_pulang'] ?></span>
                                <?php else: ?>
                                    <span class="text-muted small">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php 
                                    $statusClass = 'status-' . strtolower(str_replace(' ', '-', $row['status']));
                                    if ($row['status'] == 'Cepat Pulang') $statusClass = 'status-cepat-pulang';
                                ?>
                                <span class="status-badge <?= $statusClass ?>">
                                    <?= strtoupper($row['status']) ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url('assets/extensions/jquery/jquery.min.js') ?>"></script>
<script src="<?= base_url('assets/extensions/datatables.net/js/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js') ?>"></script>
<script src="<?= base_url('assets/static/js/pages/datatables.js') ?>"></script>

<?= $this->endSection() ?>