<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class Sekolah extends BaseController
{
    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    public function index()
    {
        $sekolah = $this->db->table('sekolah')->where('id', 1)->get()->getRowArray();

        $data = [
            'title' => 'Profil Sekolah',
            'sekolah' => $sekolah,
            'validation' => \Config\Services::validation()
        ];

        return view('admin/sekolah/index', $data);
    }

    public function update()
    {
        if (!$this->validate([
            'nama_sekolah' => 'required',
            'npsn' => 'required',
            'alamat' => 'required',
            'kota' => 'required',
            'kode_pos' => 'required',
            'logo' => 'max_size[logo,2048]|is_image[logo]|mime_in[logo,image/jpg,image/jpeg,image/png]'
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $sekolah = $this->db->table('sekolah')->where('id', 1)->get()->getRowArray();
        
        $data = [
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'npsn' => $this->request->getPost('npsn'),
            'alamat' => $this->request->getPost('alamat'),
            'kota' => $this->request->getPost('kota'),
            'kode_pos' => $this->request->getPost('kode_pos'),
        ];

        $fileLogo = $this->request->getFile('logo');
        if ($fileLogo->isValid() && !$fileLogo->hasMoved()) {
            $newName = $fileLogo->getRandomName();
            $fileLogo->move('uploads/sekolah', $newName);

            if ($sekolah && isset($sekolah['logo']) && $sekolah['logo'] != 'default_logo.png' && file_exists('uploads/sekolah/' . $sekolah['logo'])) {
                unlink('uploads/sekolah/' . $sekolah['logo']);
            }

            $data['logo'] = $newName;
        }

        if ($sekolah) {
            $this->db->table('sekolah')->where('id', 1)->update($data);
        } else {
            if (!isset($data['logo'])) {
                $data['logo'] = 'default_logo.png';
            }
            $this->db->table('sekolah')->insert($data);
        }

        return redirect()->to('admin/sekolah')->with('success', 'Profil sekolah berhasil diperbarui.');
    }
}