<?php

namespace App\Controllers;

use App\Models\AdminModel;
use App\Models\GuruModel;
use App\Models\SiswaModel;

class Auth extends BaseController
{
    public function login()
    {
        if (session()->get('is_login')) {
            return redirect()->to(session()->get('role') . '/dashboard');
        }
        return view('auth/login');
    }

    public function prosesLogin()
    {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $adminModel = new AdminModel();
        $guruModel = new GuruModel();
        $siswaModel = new SiswaModel();

        $user = $adminModel->where('username', $username)->first();
        $role = 'admin';

        if (!$user) {
            $user = $guruModel->where('username', $username)->first();
            $role = 'guru';
        }

        if (!$user) {
            $user = $siswaModel->where('username', $username)->first();
            $role = 'siswa';
        }

        if ($user) {
            if (password_verify($password, $user['password'])) {
                $sessData = [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'nama_lengkap' => $user['nama_lengkap'],
                    'role' => $role,
                    'foto' => $user['foto'],
                    'is_login' => true
                ];
                session()->set($sessData);
                return redirect()->to($role . '/dashboard');
            }
        }

        return redirect()->back()->with('error', 'Username atau Password salah.');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
}