<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\KelasModel;

class Kelas extends BaseController
{
    protected $kelasModel;

    public function __construct()
    {
        $this->kelasModel = new KelasModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Data Kelas',
            'kelas' => $this->kelasModel->findAll()
        ];
        return view('admin/kelas/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Kelas',
            'validation' => \Config\Services::validation()
        ];
        return view('admin/kelas/create', $data);
    }

    public function store()
    {
        if (!$this->validate([
            'nama_kelas' => 'required|is_unique[kelas.nama_kelas]'
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $this->kelasModel->save([
            'nama_kelas' => $this->request->getPost('nama_kelas')
        ]);

        return redirect()->to('admin/kelas')->with('success', 'Data Kelas berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $data = [
            'title' => 'Edit Kelas',
            'kelas' => $this->kelasModel->find($id),
            'validation' => \Config\Services::validation()
        ];
        return view('admin/kelas/edit', $data);
    }

    public function update($id)
    {
        if (!$this->validate([
            'nama_kelas' => "required|is_unique[kelas.nama_kelas,id,$id]"
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $this->kelasModel->update($id, [
            'nama_kelas' => $this->request->getPost('nama_kelas')
        ]);

        return redirect()->to('admin/kelas')->with('success', 'Data Kelas berhasil diperbarui.');
    }

    public function delete($id)
    {
        $this->kelasModel->delete($id);
        return redirect()->to('admin/kelas')->with('success', 'Data Kelas berhasil dihapus.');
    }
}