<?= $this->extend('layouts/app'); ?>

<?= $this->section('content'); ?>
<div class="page-heading">
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h3>Edit Soal Benar/Salah (Admin)</h3>
                <p class="text-subtitle text-muted">Koreksi soal tipe pernyataan benar atau salah.</p>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first text-end">
                <a href="<?= base_url("admin/bank_soal/list/{$soal['kelas_id']}/{$soal['mapel_id']}") ?>" class="btn btn-light-secondary shadow-sm">
                    <i class="bi bi-arrow-left me-2"></i> Batal & Kembali
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-content">
    <form action="<?= base_url('admin/bank_soal/update/' . $soal['id']) ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        <input type="hidden" name="jenis" value="benar_salah">

        <div class="row">
            <div class="col-12 col-lg-8">
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom pb-3">
                        <h5 class="card-title m-0 text-primary">
                            <i class="bi bi-pencil-square me-2"></i> 
                            Pernyataan Soal
                        </h5>
                    </div>
                    <div class="card-body pt-4">
                        <div class="form-group mb-4">
                            <label class="form-label fw-bold text-dark mb-2">Teks Pernyataan</label>
                            <textarea name="pertanyaan" class="form-control" rows="5" required><?= $soal['pertanyaan'] ?></textarea>
                        </div>

                        <?php if ($soal['file_soal']) : ?>
                            <div class="form-group mb-4">
                                <label class="form-label text-muted d-block">Gambar Terlampir:</label>
                                <img src="<?= base_url('uploads/bank_soal/' . $soal['file_soal']) ?>" 
                                     class="img-fluid rounded border shadow-sm" 
                                     style="max-height: 200px;" 
                                     onclick="window.open(this.src, '_blank')">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-4">
                <div class="card shadow-sm border-0 sticky-top" style="top: 20px;">
                    <div class="card-header bg-success text-white">
                        <h5 class="card-title m-0 text-white"><i class="bi bi-check-circle me-2"></i> Kunci Jawaban</h5>
                    </div>
                    <div class="card-body pt-4">
                        <div class="alert alert-light-success color-success mb-3">
                            <i class="bi bi-info-circle me-1"></i> Tentukan apakah pernyataan tersebut Benar atau Salah.
                        </div>

                        <div class="form-group">
                            <label class="form-label fw-bold mb-3">Jawaban yang Tepat:</label>
                            
                            <div class="d-grid gap-2">
                                <div class="form-check card-hover p-3 border rounded <?= ($soal['kunci_jawaban'] == 'Benar') ? 'border-success bg-light-success' : '' ?>">
                                    <input class="form-check-input ms-1" type="radio" name="kunci_jawaban" 
                                           id="kunci_benar" value="Benar" 
                                           <?= ($soal['kunci_jawaban'] == 'Benar') ? 'checked' : '' ?> required>
                                    <label class="form-check-label fw-bold ms-2 cursor-pointer w-100 text-success" for="kunci_benar">
                                        BENAR
                                    </label>
                                </div>

                                <div class="form-check card-hover p-3 border rounded <?= ($soal['kunci_jawaban'] == 'Salah') ? 'border-danger bg-light-danger' : '' ?>">
                                    <input class="form-check-input ms-1" type="radio" name="kunci_jawaban" 
                                           id="kunci_salah" value="Salah" 
                                           <?= ($soal['kunci_jawaban'] == 'Salah') ? 'checked' : '' ?> required>
                                    <label class="form-check-label fw-bold ms-2 cursor-pointer w-100 text-danger" for="kunci_salah">
                                        SALAH
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-12 mt-3">
                <div class="card shadow-sm">
                    <div class="card-body d-flex justify-content-end gap-2">
                        <a href="<?= base_url("admin/bank_soal/list/{$soal['kelas_id']}/{$soal['mapel_id']}") ?>" class="btn btn-light-secondary">
                            Batal
                        </a>
                        <button type="submit" class="btn btn-primary px-4 shadow">
                            <i class="bi bi-save-fill me-2"></i> Simpan Perubahan (Admin)
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?= $this->endSection(); ?>